#ifndef CONFIG
#define CONFIG

/* Arduino */

#define CPU_CLOCK_FREQ 16000000   // 16MHz

const uint16_t arrayEEPROM[11] = {// Address in memory cells of EEPROM:
  500,                            // [0] XTAL_CORRECT (4 bytes)
  504,                            // [1] SI5351BX_CPF (1 byte)
  505,                            // [2] empty        (4 bytes)
  509,                            // [3] calibration Vbatt (4 bytes)
  513,                            // [4] brightness of LED indicator (1 byte)
  514,                            // [5] soundLevelRX 0-79 (1 byte)
  515,                            // [6] soundLevelTX 0-79 (1 byte)
  516,                            // [7] soundLevelCW 0-79 (1 byte)
  517,                            // [8] Tone CW 300-2400 Hz (4 byte)
  521,                            // [9] empty
  0                               // [10] Channels 0-99 F,SSB (4+1 bytes)
};

/* Si5351 module */

#define CLK_VFO        0          // Number of CLK for VFO/BFO/TX0
#define CLK_TX0        1
#define CLK_BFO        2

#define POWER_VFO      2          // CLK level VFO/BFO/TX0: 0=2ma 1=4ma 2=6ma 3=8ma
#define POWER_BFO      2          //                   dBm:  ~2.2  ~7.5  ~9.5  ~10.7
#define POWER_TX0      1

const uint32_t XTAL_SI5351 = 25000000;  // XTAL frequency Si5351a module.
uint32_t XTAL_CORRECT;            // XTAL frequency correction constant
uint8_t  SI5351BX_CPF;            // 1:6pf  2:8pf  3:10pf
uint8_t si5351bx_drive[3];

/* Buttons */

//   BTN_KEY      [04]   BTN_VALUE_UP [06]   BTN_SOUND_UP [08]
//   BTN_SELECTOR [05]   BTN_VALUE_DW [07]   BTN_SOUND_DW [10]

#define BTN_SELECTOR   5          //  D5,  5 IDE, Select button
#define BTN_VALUE_UP   6          //  D6,  6 IDE, Value+ button
#define BTN_VALUE_DW   7          //  D7,  7 IDE, Value- button
#define BTN_SOUND_UP   8          //  D8,  8 IDE, Sound+ button
#define BTN_SOUND_DW   10         // D10, 10 IDE, Sound- button

/* Display MT1637 module */

uint8_t brightness;
uint8_t digits[5];

#define PIN_DIO        11         // D11, 11 IDE, TM1637 Data
#define PIN_CLK        12         // D12, 12 IDE, TM1637 Clock

/* CW */

#define BTN_KEY        4          //  D4,  4 IDE, CW Key
#define PIN_TONE       9          //  D9,  9 IDE, CW self-control tone

/* Output digital ports */

#define PIN_RX         2          //  D2,  2 IDE, RX
//#define PIN_TX         13         // D13, 13 IDE, TX
#define PIN_DRIVER     3          //  D3,  3 IDE, Power TX drive control

/* Input analog ports */

#define Forward        A0         //  14 IDE, SWR Forward voltage
#define Reflect        A1         //  15 IDE, SWR Reflect voltage
#define Battery        A2         //  16 IDE,     Battery voltage
//      AudioInput     A3         //  17 IDE, TX Input Audio Signal

/* CAT interface IC-746 */

#define MODE_LSB       00
#define MODE_USB       01

const uint32_t BAUDRATE= 19200;   // Baudrate of UART in FLDIGI, JS8Call, etc. SERIAL_8N1 mode.
const uint32_t Fmin    = 2500000; // Min frequency
const uint32_t Fmax    = 6200000; // Max frequency
const uint32_t BFO_LSB = 4192450; //        .
const uint32_t BFO_USB = 4195100; //       .
uint32_t F0            = 3579000; // Start frequency 3.579 MHz
uint32_t CW_TONE;
uint8_t  MODE_SSB      = MODE_USB;

//     W = B0 + B1*x + B2*x^2 + B3*x^3 + B4*x^4 
//         => PowerPolinom[] = {B0, B1, B2, B3, B4};
//const float PowerPolinom[] = {0.00226, 3.35505E-4, 4.72405E-6, -3.79996E-9, 2.36547E-12};
  const float PowerPolinom[] = {0.0015,  6.68039E-4, 3.36523E-6, -1.62473E-9, 1.31391E-12};

/* Flags */

bool     TX            = false;
bool     CW            = false;
bool     tuning        = false;
bool     calibrationV  = false;
bool     displayoff    = false;
uint8_t  scan          = 0;       // [0]-no scan, [1]-=1 kHz,     [2]+=1 kHz;
uint8_t  mode          = 0;       // [1] - freq   [2] - channel   [3] - voltage
                                  // [4] - CW     [5] - SWRmeter  [6] - Powermeter
                                  // [7] - bright [8] - XTAL-F    [9] - XTAL-C
                                  // [10] - tune 

/* Counters */

uint8_t  soundLevelRX;            // 0-79; 79 - max volume, 0 - mute.
uint8_t  soundLevelTX;            // 0-79; 79 - max volume, 0 - mute.
uint8_t  soundLevelCW;            // 0-79; 79 - max volume, 0 - mute.
int16_t  volt          = 0;       // 0-1023
uint8_t  channel       = 0;       // 0-99;
uint8_t  powerLevel    = 255;     // Start level of TX driver power, 0 - off, < 255 - on.
const uint8_t powerLevelMin = 70;
const uint8_t powerLevelMax = 255;

#endif
