/*************************************************************************
   IC746 CAT Library, by KK4DAS, Dean Souleles
   V1.1 2/3/202 
      - various fixes, now works properly with OmniRig and flrig
      - smeter now returns proper BCD code - calibrated to emulate ICOM responses
      
   V1.0 1/24/2021
      - Initial build

   Inspired by: FT857D CAT Library, by Pavel Milanes, CO7WT, pavelmc@gmail.com

   The goal of this lib is to emulate an ICOM 746 CAT functionality
   to work with all ham radio software that include CAT control

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

 * **************************************************************************/

#ifndef IC746_h
#define IC746_h

#include <Arduino.h>

// CAT Command definitions from IC746 Manual

// Protocol
  #define CAT_PREAMBLE        0xFE  // sent twice at start of command
  #define CAT_EOM             0xFD  // end of message
  #define CAT_ACK             0xFB  // OK
  #define CAT_NACK            0xFA  // No good
  #define CAT_RIG_ADDR        0x56  // Rig ID for IC746
  #define CAT_CTRL_ADDR       0xE0  // Controller ID


// Commands
  #define CAT_READ_FREQ       0x03  // Reads display frequency
  #define CAT_READ_MODE       0x04  // Reads display mode
  #define CAT_SET_FREQ        0x05  // Sets frequency
  #define CAT_SET_MODE        0x06  // Sets LSB/USB mode
  #define CAT_READ_ID         0x19  // Reads the transceivers ID code
  #define CAT_PTT             0x1C  // Exchanges transmit and receive (0=Rx, 1=Tx)

// CAT Sub COmmands

// Mode Subcommand
  #define CAT_MODE_LSB        0x00  // LSB
  #define CAT_MODE_USB        0x01  // USB
  #define CAT_MODE_ADD        0x02  // AM
  #define CAT_MODE_DEL        0x05  // FM
  #define CAT_MODE_FILTER1    0x01  // Required for "read mode"

// PTT Subcommand
  #define CAT_PTT_RX          0x00  // RX
  #define CAT_PTT_TX          0x01  // TX

// Command Receive States
  #define CAT_RCV_WAITING     0  // waiting for 1st preamble byte
  #define CAT_RCV_INIT        1  // waiting for 2nd preamble byte
  #define CAT_RCV_RECEIVING   2  // waiting for command bytes

// Command buffer (without preamble and EOM)
// |FE|FE|56|E0|cmd|sub-cmd|data|FD|  // Preamble (FE) and EOM (FD) are discarded leaving
// 2 addr bytes , 1 command, 1 sub-command, up to 12 data, (longest is unimplemented edge frequency)
 #define CAT_CMD_BUF_LENGTH  16

// defining the funtion type by params
typedef void (*FuncPtrVoid)(void);
typedef long (*FuncPtrVoidLong)(void);
typedef byte (*FuncPtrVoidByte)(void);
typedef void (*FuncPtrBoolean)(boolean);
typedef boolean (*FuncPtrVoidBoolean)(void);
typedef void (*FuncPtrByte)(byte);
typedef void (*FuncPtrLong)(long);


class IC746 {
  public:
    // we have two kind of constructors here
    void begin();
    void begin(long baudrate, int mode);
    void check();

    // the functions that links the lib with user supplied functions
    void addCATPtt(void (*)(boolean));
    void addCATFSet(void (*)(long));
    void addCATMSet(void (*)(byte));
    void addCATGetFreq(long (*)(void));
    void addCATGetMode(byte (*)(void));
    void addCATGetPtt(boolean (*)(void));

    boolean enabled = true;

  private:
    byte cmdBuf[CAT_CMD_BUF_LENGTH];
    byte rcvState   = CAT_RCV_WAITING;
    boolean cmdRcvd = false;
    int bytesRcvd   = 0;
    int cmdLength   = 0;
    long freq       = 0;
    void setFreq(void);
    void send(byte *, int);
    void sendResponse(byte *buf, int len);
    void sendAck(void);
    void sendNack(void);
    boolean readCmd(void);
    long BCDtoFreq(void);
    void FreqtoBCD(long);
    void doPtt();
    void doSetFreq();
    void doReadFreq();
    void doSetMode();
    void doReadMode();
};

#endif
