
/* Arduino */

#define CPU_CLOCK_FREQ 16000000   // 16MHz arrayEEPROM[14]

/* Si5351 module */

#define CLK_VFO        0          // Number of CLK for VFO/BFO/TX0
#define CLK_TX0        1
#define CLK_BFO        2

#define POWER_VFO      2          // CLK level VFO/BFO/TX0: 0=2ma 1=4ma 2=6ma 3=8ma
#define POWER_BFO      2          //                   dBm:  ~2.2  ~7.5  ~9.5  ~10.7
#define POWER_TX0      1

const uint32_t XTAL_SI5351 = 25000000;  // XTAL frequency Si5351a module.

/* Buttons */

//   BTN_KEY      [04]   BTN_VALUE_UP [06]   BTN_SOUND_UP [08]
//   BTN_SELECTOR [05]   BTN_VALUE_DW [07]   BTN_SOUND_DW [10]

#define BTN_SELECTOR   5          //  D5,  5 IDE, Select button
#define BTN_VALUE_UP   6          //  D6,  6 IDE, Value+ button
#define BTN_VALUE_DW   7          //  D7,  7 IDE, Value- button
#define BTN_SOUND_UP   8          //  D8,  8 IDE, Sound+ button
#define BTN_SOUND_DW   10         // D10, 10 IDE, Sound- button

/* Display MT1637 module */

#define PIN_DIO        11         // D11, 11 IDE, TM1637 Data
#define PIN_CLK        12         // D12, 12 IDE, TM1637 Clock

/* CW */

#define BTN_KEY        4          //  D4,  4 IDE, CW Key
#define PIN_TONE       9          //  D9,  9 IDE, CW self-control tone
#define WPM_INFOMER    24          // Morse voicing errors, 24 WPM

/* Output digital ports */

#define PIN_RX         2          //  D2,  2 IDE, RX
//#define PIN_TX         13         // D13, 13 IDE, TX
#define PIN_DRIVER     3          //  D3,  3 IDE, Power TX drive control

/* Input analog ports */

#define Forward        A0         //  14 IDE, SWR Forward voltage
#define Reflect        A1         //  15 IDE, SWR Reflect voltage
#define Battery        A2         //  16 IDE,     Battery voltage
//      AudioInput     A3         //  17 IDE, TX Input Audio Signal

/* CAT interface IC-746 */

#define MODE_LSB       00
#define MODE_USB       01

const uint32_t BAUDRATE= 19200;   // Baudrate of UART in FLDIGI, JS8Call, etc. SERIAL_8N1 mode.

/* Frequency limitation */

const uint32_t FminRX  = 2000000; // Min RX frequency
const uint32_t FmaxRX  = 6200000; // Max RX frequency
const uint32_t FminTX  = 2900000; // Min TX frequency
const uint32_t FmaxTX  = 3800000; // Max TX frequency
const uint32_t BFO_LSB = 4192450; // опора на нижнем  скате АЧХ кварцевого фильтра.
const uint32_t BFO_USB = 4195100; // опора на верхнем скате АЧХ кварцевого фильтра.
uint32_t F0            = 3579000; // Start frequency 3.579 MHz

/* Power */

#define powerPWM       1          // 1 - PWM, 0 - no power adjustment.
#define powerLevelMin  70
#define powerLevelMax  255

uint8_t  powerLevel    = 255;     // Default Power in points, powerLevelMin <= value <= powerLevelMax
int16_t  powerVariable = 3000;    // Default Power in mW
uint16_t powermenu     = 2100;    // Default Power mode, 0 - SWR, 2000 - Power in points, 2100 - Power in Watt 

// W = B0 + B1*x + B2*x^2 + B3*x^3 + B4*x^4  => PowerPolinom[] = {B0, B1, B2, B3, B4};
const float PowerPolinom[] = {
  0.0015,      6.68039E-4,    3.36523E-6,    -1.62473E-9,   1.31391E-12
};

/* Beacon */

// All messages UpperCase only. LowerCase letters are not passed.
// Message length up to 30 letters "                              "← End here.
const char beaconText0[] PROGMEM = "CQ BEACON NO14 E";
const char beaconText1[] PROGMEM = "CQ BEACON NO14 I";
const char beaconText2[] PROGMEM = "CQ BEACON NO14 S";
const char beaconText3[] PROGMEM = "CQ BEACON NO14 H";
const char beaconText4[] PROGMEM = "CQ BEACON NO14 5";
const char beaconText5[] PROGMEM = "CQ BEACON NO14 T";
const char beaconText6[] PROGMEM = "CQ BEACON NO14 M";
const char beaconText7[] PROGMEM = "CQ BEACON NO14 O";
const char beaconText8[] PROGMEM = "CQ BEACON NO14 MM";
const char beaconText9[] PROGMEM = "CQ BEACON NO14 0";
