#include <Arduino.h>
#include <Wire.h>
#include "PT2257.h"

/* Pinout
   |-----_-----|
1 -| Lin   Rin |- 8
2 -| Lout Rout |- 7
3 -| Gnd    V+ |- 6
4 -| SDA   SCL |- 5
   |-----------|
*/

PT2257::PT2257(){
  Wire.begin();
}

void PT2257::Left(uint8_t db){
  db = 79 - db;
  int db10 = db / 10;
  int db01 = db - db10 * 10;

  writeWire(db10 + 0b10110000);
  writeWire(db01 + 0b10100000);
}

void PT2257::Right(uint8_t db){
  db = 79 - db;
  int db10 = db / 10;
  int db01 = db - db10 * 10;

  writeWire(db10 + 0b00110000);
  writeWire(db01 + 0b00100000);
}

void PT2257::Mute(bool mute){
  if (mute) writeWire(0b01111001); else writeWire(0b01111000);
}

void PT2257::writeWire(char a){
  Wire.beginTransmission(PT2257_address);
  Wire.write(a);
  Wire.endTransmission();
}
