/*
 * TM1637.cpp
 * A library for the 4 digit display
 *
 * Copyright (c) 2012 seeed technology inc.
 * Website    : www.seeed.cc
 * Author     : Frankie.Chu
 * Create Time: 9 April,2012
 * Change Log :
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "TM1637mod.h"
#include <Arduino.h>

//    ---A---
//   |       |
//   F       B
//   |       |
//    ---G---
//   |       |
//   E       C
//   |       |
//    ---D--- H

static int8_t TubeTab[] = {
//    HGFEDCBA
    0b00111111,  // 0
    0b00000110,  // 1
    0b01011011,  // 2
    0b01001111,  // 3
    0b01100110,  // 4
    0b01101101,  // 5
    0b01111101,  // 6
    0b00000111,  // 7
    0b01111111,  // 8
    0b01101111,  // 9
    0b00000000,  // 10 empty
};

TM1637::TM1637(byte Clok, byte Data) {
 	Clokpin = Clok;
  	Datapin = Data;
	pinMode(Clokpin, OUTPUT);
	pinMode(Datapin, OUTPUT);
}

void TM1637::init(void) {
	clearDisplay();
}

void TM1637::writeByte(int8_t wr_data) {
   byte count1;
   
   for (byte i = 0; i < 8; i++) {
      digitalWrite(Clokpin, LOW);
      digitalWrite(Datapin, (wr_data & 0x01 ?  HIGH: LOW));
		wr_data >>= 1;      
		digitalWrite(Clokpin, HIGH);
   }  
   digitalWrite(Clokpin, LOW);
   digitalWrite(Datapin, HIGH);
   digitalWrite(Clokpin, HIGH);
   pinMode(Datapin, INPUT);
   while(digitalRead(Datapin)) {
      count1 += 1;
      if (count1 == 200) {
         pinMode(Datapin, OUTPUT);
         digitalWrite(Datapin, LOW);
         count1 = 0;
      }
      pinMode(Datapin, INPUT);
   }
   pinMode(Datapin, OUTPUT);
}

void TM1637::start(void) {
   digitalWrite(Clokpin, HIGH);
   digitalWrite(Datapin, HIGH);
   digitalWrite(Datapin, LOW);
   digitalWrite(Clokpin, LOW);
} 

void TM1637::stop(void) {
   digitalWrite(Clokpin, LOW);
   digitalWrite(Datapin, LOW);
   digitalWrite(Clokpin, HIGH);
   digitalWrite(Datapin, HIGH);
}

void TM1637::display(int8_t DispData[]) {
   int8_t SegData[4];

   for (byte i = 0; i < 4; i++) {
      SegData[i] = DispData[i];
   }
   coding(SegData);
   start();
   writeByte(ADDR_AUTO);
   stop();
   start();
   writeByte(Cmd_SetAddr);
   for (byte i = 0; i < 4; i++) {
      writeByte(SegData[i]);
   }
   stop();
   start();
   writeByte(Cmd_DispCtrl);
   stop();
}

void TM1637::display(byte BitAddr, int8_t DispData) {
   int8_t SegData;
   
   SegData = coding(DispData);
   start();
   writeByte(ADDR_FIXED);
   stop();
   start();
   writeByte(BitAddr|0xc0);
   writeByte(SegData);
   stop();
   start();
   writeByte(Cmd_DispCtrl);
   stop();
}

void TM1637::clearDisplay(void) {
   display(0x00, 0x7f);
   display(0x01, 0x7f);
   display(0x02, 0x7f);
   display(0x03, 0x7f);  
}

void TM1637::set(byte brightness, byte SetData, byte SetAddr) {
   Cmd_SetData = SetData;
   Cmd_SetAddr = SetAddr;
   Cmd_DispCtrl = 0x88 + brightness;
}

void TM1637::point(bool PointFlag) {
   PointData = PointFlag == true ? 0x80: 0;
}

void TM1637::coding(int8_t DispData[]) {
	for (byte i = 0; i < 4; i++) {    
      DispData[i] = DispData[i] == 0x7f ? 0x00: (DispData[i] > 10 ? DispData[i]: TubeTab[DispData[i]]) + PointData; // mod
	}
}

int8_t TM1637::coding(int8_t DispData) {
   DispData = DispData == 0x7f ? 0x00: (DispData > 10 ? DispData: TubeTab[DispData]); // mod
   return DispData + PointData; // mod
}
