/*
 * TM1637.h
 * A library for the 4 digit display
 *
 * Copyright (c) 2012 seeed technology inc.
 * Website    : www.seeed.cc
 * Author     : Frankie.Chu
 * Create Time: 9 April,2012
 * Change Log :
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef TM1637_h
#define TM1637_h
#include <inttypes.h>
#include <Arduino.h>

#define ADDR_AUTO  0x40
#define ADDR_FIXED 0x44

class TM1637
{
  public:
    byte Cmd_SetData;
    byte Cmd_SetAddr;
    byte Cmd_DispCtrl;

    TM1637(byte, byte);
    void init(void);
    void writeByte(int8_t wr_data);
    void start(void);
    void stop(void);
    void display(int8_t DispData[]);
    void display(byte BitAddr, int8_t DispData);
    void clearDisplay(void);
    void set(byte = 2, byte = 0x40, byte = 0xc0);
    void point(bool PointFlag);
    void coding(int8_t DispData[]); 
    int8_t coding(int8_t DispData); 
  private:
    byte Clokpin;
    byte Datapin;
    byte PointData;
};
#endif
