#include "Arduino.h"
#include "adc.h"

void adc::rx(void) {
  ADMUX  = 0b00000000;                 // REFS1 REFS0? ADLAR - MUX3 MUX2 MUX1 MUX0
  ADCSRA = 0b10000111;                 // ADEN+ ADSC ADATE ADIF ADIE ADPS2+ ADPS1+ ADPS0+    =CLK/128
  ADCSRB = 0b00000000;                 // - ACME+ - - - ADTS2 ADTS1 ADTS0
  ACSR   = 0b00010000;                 // ACD ACBG ACO ACI+ ACIE ACIC ACIS1 ACIS0
  noInterrupts();
  TCCR1A = 0b00000001;                 // COM1A1 COM1A0 COM1B1 COM1B0 - - PWM11 PWM10+
  TCCR1B = 0b00000011;                 // ICNC1 ICES1 - - CTC1 CS12 CS11+ CS10+              =CK/64
  TCCR1C = 0b00000000;                 // FOC1A FOC1B - - - - - -
  TIMSK1 = 0b00000000;                 // - - ICIE1 - - OCIE1B OCIE1A TOIE1
  TIFR1  = 0b00100111;                 // - - ICF1+ - - OCF1B+ OCF1A+ TOV1+
  ICR1   = 0;
  PCICR  = 0;                          // disable external interrupts:
  PCMSK0 = 0;
  PCMSK1 = 0;
  PCMSK2 = 0;
  delay(1);
  interrupts();
}

void adc::tx(uint8_t An = 54) {       

       if (54 <= An && An <= 61) ADMUX = An - 54;    // Mega: A0-A7 only .\hardware\arduino\avr\variants\mega\pins_arduino.h
  else if (14 <= An && An <= 21) ADMUX = An - 14;    // Nano: A0-A7 only .\hardware\arduino\avr\variants\standard\pins_arduino.h
  else                           ADMUX = 0b00000000; // A0

/*
   - 7  6 - REFS 1.. (Reference Selection Bits) -     
              AREF - . (11?2.56)
            00 AREF,   Vref 
   - 5 - ADLAR (ADC Left Adjust Result) -        
            ADCL  ADCH.  ADLAR=0    8- .
   - 43210 - MUX4..MUX0 (Multiplexer bits) -    ,    .
            00000 ADC0
            00001 ADC1
            00010 ADC2
            00011 ADC3
            00100 ADC4
            00101 ADC5
            00110 ADC6
            00111 ADC7
*/

  ADCSRA = 0b00000000;                 // ADEN ADSC ADATE ADIF ADIE ADPS2 ADPS1 ADPS0
  
/*
   + 7 - ADEN (ADC Enable) -   - .
   + 6 - ADSC (ADC Start Conversion) -     . 
                   1
   + 5 - ADATE (ADC Auto Trigger Enable).    ADC. 
                  ADC. 
            ADC        . 
                  ADTS (ADC Trigger Select) 
                SFIOR.
   - 4 - ADIF (ADC Interrupt Flag).    . 
                  ADC    . 
            -      ADC (  1C). 
                ,     , 
            ADIE   1-    SREG. 
             ADIF       .
   - 3 - ADIE (ADC Interrupt Enable) -   .
     2:0 - ADPS2:0 (ADC Prescaler Select Bits) -    .
            101=32 (0xe5)
*/
  
  ADCSRB = 0b01000000;                 // - ACME+ - - - ADTS2 ADTS1 ADTS0
  ACSR   = 0b01000111;                 // ACD ACBG+ ACO ACI ACIE ACIC+ ACIS1+ ACIS0+
  noInterrupts();
  TCCR1A = 0b00000000;                 // COM1A1 COM1A0 COM1B1 COM1B0 - - PWM11 PWM10
  TCCR1B = 0b11000001;                 // ICNC1+ ICES1+ - - CTC1 CS12 CS11 CS10+              =CK/1
  TCCR1C = 0b00000000;                 // FOC1A FOC1B - - - - - -
  ICR1 = 0;
  TIMSK1 = 0b00100001;                 // - - ICIE1+ - - OCIE1B OCIE1A TOIE1+
  TIFR1  = 0b00000110;                 // - - ICF1 - - OCF1B+ OCF1A+ TOV1
  delay(1);
  interrupts();
}
