// Status (Scan1-Scan0-swrmode1-swrmode2-CW-TX-Tune-Led)

const uint32_t CPU_CLOCK_FREQ = 16000000; // Arduino module frequency.
const uint32_t XTAL_QUARTZ    = 25000000; // Si5351a module frequency.

/* Buttons to GND */

//   BTN_KEY      [04]   BTN_VALUE_UP [06]   BTN_SOUND_UP [08]
//   BTN_SELECTOR [05]   BTN_VALUE_DW [07]   BTN_SOUND_DW [10]

#define BTN_KEY        4                  //  D4,  4 IDE, CW Key
#define BTN_SELECTOR   5                  //  D5,  5 IDE, Select button
#define BTN_VALUE_UP   6                  //  D6,  6 IDE, Value+ button
#define BTN_VALUE_DW   7                  //  D7,  7 IDE, Value- button
#define BTN_SOUND_UP   8                  //  D8,  8 IDE, Sound+ button
#define BTN_SOUND_DW   10                 // D10, 10 IDE, Sound- button

/* Display MT1637 module */

#define PIN_DIO        11                 // D11, 11 IDE, TM1637 Data
#define PIN_CLK        12                 // D12, 12 IDE, TM1637 Clock

/* Beeper */

#define PIN_TONE_D9    9                  //  D9,  9 IDE, CW self-control tone

/* Output digital ports */

#define PIN_RX         2                  //  D2,  2 IDE, RX
#define PIN_DRIVER     3                  //  D3,  3 IDE, Power TX drive control

/* Input analog ports */

#define PIN_FORWARD    A0                 //  14 IDE, SWR Forward voltage
#define PIN_REFLECT    A1                 //  15 IDE, SWR Reflect voltage
#define PIN_VOLTAGE    A2                 //  16 IDE,     Battery voltage
#define AudioInput     A3                 //  17 IDE, TX Input Audio Signal

/* CAT interface IC-746 */

#define MODE_LSB       00
#define MODE_USB       01

const  int32_t BAUDRATE     = 9600;       // Baudrate of UART in FLDIGI, JS8Call, etc. SERIAL_8N1 mode.
const  int16_t SERIAL_MODE  = SERIAL_8N1; // Arduino mode for the serial. 

/* Frequency limitation */

const uint32_t FminRX       = 2000000;    // Min RX frequency, kHz
const uint32_t FmaxRX       = 6200000;    // Max RX frequency, kHz
const uint32_t FminTX       = 2900000;    // Min TX frequency, kHz
const uint32_t FmaxTX       = 3800000;    // Max TX frequency, kHz
const uint32_t F0           = 3579000;    // Start frequency 3.579 MHz
const uint32_t BFO_LSB      = 4192450;    // опора на нижнем  скате АЧХ кварцевого фильтра.
const uint32_t BFO_USB      = 4195100;    // опора на верхнем скате АЧХ кварцевого фильтра.
const uint32_t TUNE_TONE    = 600;        // Tune Tone.

/* Power */

const uint8_t  setPowerVarMin = 90;       // Min Power in points
const uint8_t  setPowerVarMax = 255;      // Max Power in points
      uint8_t  setPowerVar    = 255;      // Default Power in points, setPowerVarMin <= setPowerVar <= setPowerVarMax
const uint16_t power_mWt_Max  = 3000;     // maximum possible power in mW

// W = B0 + B1*x + B2*x^2 + B3*x^3 + B4*x^4  => PowerPolinom[] = {B0, B1, B2, B3, B4};
const float PowerPolinom[] = {
  0.0015,      6.68039E-4,    3.36523E-6,    -1.62473E-9,   1.31391E-12
};

const   address memory = {
  10,                                     // [4b] Start frequency F0 in Hz (3579000)
  14,                                     // [1b] Sideband CAT_MODE_LSB or CAT_MODE_USB
  15,                                     // [1b] LED Brightness.
  16,                                     // [4b] calibration V batt
  20,                                     // [2b] XTAL frequency correction constant
  22,                                     // [1b] XTAL capacitor
  23,                                     // [1b] soundLevelRX
  24,                                     // [1b] soundLevelTX
  25,                                     // [1b] soundLevelCW
  26,                                     // [2b] power_mW
  
  52,                                     // [4b*50] Channels F,SSB [01-50] [0]52-55 not use! [1]56-59 ... [50]252-255
};